@extends('layouts.app')
@section('title', 'Deleted Sales (Trash)')

@section('content')
<section class="content-header">
  <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">Deleted Sales (Trash)</h1>
</section>

<section class="content">
  @if(session('status'))
    <div class="alert alert-success">{{ session('status') }}</div>
  @endif

  <div class="box">
    <div class="box-body table-responsive">
      <table class="table table-striped table-bordered">
       <thead>
  <tr>
    <th>Deleted At</th>
    <th>Invoice #</th>
    <th>Customer</th>
    <th>Location</th>
    <th>Final Total</th>
    <th>Deleted By</th>     {{-- NEW --}}
    <th>Actions</th>
  </tr>
</thead>
<tbody>
@forelse($rows as $tx)
  <tr>
    <td>{{ optional($tx->deleted_at)->format('Y-m-d H:i') }}</td>
    <td>{{ $tx->invoice_no }}</td>
    <td>{{ optional($tx->contact)->name }}</td>
    <td>{{ optional($tx->location)->name }}</td>
    <td>{{ number_format($tx->final_total, 2) }}</td>
    <td>{{ $tx->deleted_by_email ?? '—' }}</td>  {{-- NEW --}}
    <td class="text-nowrap">
      <a href="#"
         class="btn btn-primary btn-xs btn-modal"
         data-href="{{ action(\App\Http\Controllers\SellController::class.'@trashedShow', $tx->id) }}"
         data-container=".view_modal">
        <i class="fa fa-eye"></i> View
      </a>
    </td>
  </tr>
@empty
  <tr><td colspan="7" class="text-center">No deleted sales.</td></tr>
@endforelse
</tbody>

      </table>

      <div class="text-center">
        {{ $rows->links() }}
      </div>
    </div>
  </div>
</section>


@endsection
